<?php

    /**
    *
    * copyright (c) 2015-2017 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    */

    class QueryJson {
        private $db;
        private $datiJson;
        private $query;
        
        /* 
         *  il json passato in input deve avere: 
         *  tipoQuery
         *  table
         *  
         */
        function __construct($db,$datiJson) {
            $this->db = $db;
            $this->datiJson = $datiJson;
	    $this->query = "";
        }

        public function costruisciQuery() {
            $tabella = $this->datiJson->table;
            switch ($this->datiJson->tipoQuery) {
                case'select':
                   $this->query = "SELECT * FROM $tabella";
                   break;
                case'update':
                   $this->query = "UPDATE $tabella SET ";
                   $parametriUpdate = $this->datiJson->updateParameter;

                   $numeroParametri = count($parametriUpdate);
		     $i = 0;
                   foreach($parametriUpdate as $parametro) {
                       $this->query .= "$parametro->name='$parametro->value'";
			  if($i++ != $numeroParametri) {
                       	$this->query .= ", ";
			  }
			  $i++;
                   }

		   $this->query .= " WHERE ";
                   $parametriWhere = $this->datiJson->whereParameter;
                   $numeroParametri = count($parametriWhere);
		   $i = 0;
                   foreach($parametriWhere as $parametro) {
			  if($i==0) {
                      	$this->query .= "$parametro->name='$parametro->value'";
			  }
			  else {
                      	$this->query .= "AND $parametro->name='$parametro->value'";
			  }
			  $i++;
                   }
                   break;
               case'insert':
                   $this->query = "INSERT INTO $tabella VALUES(";
                   $insertParameter = $this->datiJson->insertParameter;
                   $numeroParametri = count($insertParameter);
		     $i = 0;
                   foreach($insertParameter as $parametro) {
                       $this->query .= "'$parametro->value'";
			  if($i++ == $numeroParametri) {
                       	$this->query .= ")";
			  }
			  else {
                       	$this->query .= ",";
			  }
			  $i++;
                   }
                   break;
            }
        }
        
        function executeQuery() {
            if($this->datiJson->tipoQuery=="select") {            
                $this->db->eseguiQueryLettura($this->query);
            }
            else {
                $this->db->eseguiQueryScrittura($this->query);
            }
        }
        
        function getDb() {
            return $this->db;
        }

        function getJsonData() {
            return $this->datiJson;
        }

        function getQuery() {
            return $this->query;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setJsonData($datiJson) {
            $this->datiJson = $datiJson;
        }

        function setQuery($query) {
            $this->query = $query;
        }
    }